main       START
*******************************************************************************
*
* GENESYS Project - Shell main.. The Smurf Decoder Ring!
*
* Author:  Marc Wolfgram and Kevin Seidule
*          --------------------------------------------------------------------
* Started: 1.0a1   1Apr89      FOR THE COMPLETE REVISION HISTORY OF THE GENESYS
*    Beta: 1.0b1  21Mar90         SHELL REFER TO THE FILE "GENESYS.HISTORY"
*   Final: 1.0     1May90
*   Final: 1.1     1Sep90
*   Final: 1.2    27Oct90
*          --------------------------------------------------------------------
* Revised: 2.0a1  27Oct90 It never ends... preliminary resource fork and added
*                         menu event dispatch hits. Added "Center-of-the-SMURF
*                         dispatching and command 1 - 7 and 11 - 15.
*          2.0a6  11Nov90 Another day in infamy... Dependancy deletes work!!!
*          2.0a12 16Dec90 1.2.2 scg engine implemented.
*          --------------------------------------------------------------------
*
*          shError() (.CC) and jsl shError2 (.ASM) error range assignments:
*
*          Error range     File         Error range     File
*          -----------  ----------      -----------  ----------
*           0000-1FFF   SHELL.ASM        7000-7FFF   ICG.CC
*           2000-2FFF   APPLE.ASM        8000-8FFF   LAYOUT.ASM
*           3000-3FFF   EDIT.CC          9000-9FFF   MISC.CC
*           4000-5FFF   FILE2.ASM        A000-AFFF   RNAME.CC
*           6000-6FFF   HELP.ASM         B000-BFFF   SMURF.CC
*
*           DATA.ASM, ENGINE.CC and SCG.CC do not using shError() or shError2.
*
*          --------------------------------------------------------------------
*
*   Copyright 1988-1991 by Simple Software Systems International, Inc.
*
*   ALL RIGHTS RESERVED
*
*******************************************************************************
*
           case     on
           using    Shell

           copy     2/ainclude/e16.types
           copy     2/ainclude/e16.control
           copy     2/ainclude/e16.event
           copy     2/ainclude/e16.memory
           copy     2/ainclude/e16.intmath
           copy     2/ainclude/e16.window

           copy     e16.genesys
           mcopy    shell.mac

           longi    on
           longa    on

           phb                          Save caller's data bank pointer
           phd                          Save caller's direct page pointer
           phk                          Switch data bank into program bank
           plb                          Make em equal

           _TLStartup                   Start Tool Locator (KS)
           PushWord #0                  See if we die in our sleep...
           _TLVersion
           pla
           and      #$7f00              strip prototype flag from futures
           cmp      #$0300
           bge      SystemOk
           jsl      FatalStart
           brl      AbortExit

SystemOk   PushWord #0                  Startup memory manager
           _MMStartUp
           pla
           sta      MasterID

           PushLong #0                  Start up the tools using new 5.0 call
           PushWord MasterID            Our UserID
           PushWord #refIsResource
           PushLong #1
           _StartupTools                Do It!
           bcc      ToolsOk
           cmp      #$104
           beq      VersionBad

           PullLong initRef             Pointer used by ShutdownTools
           jsl      FatalStart

           brl      ShutDown

VersionBad PullLong initRef             Pointer used by ShutdownTools

           PushWord #0                  Result
           PushWord #4                  C str resource
           PushLong #0                  Substitution string
           PushLong #11
           _AlertWindow
           pla

           brl      ShutDown

ToolsOk    _GetVersionGS GSOSVer
           lda      Version
           cmp      #$0303
           blt      VersionBad

           PullLong initRef             Pointer used by ShutdownTools

           PushLong #0                  Spaced out result
           _GetWMgrPort
           _SetPort

           PushLong #LoadNote
           jsl      doAbout

           lda      MasterID            do id for editor use
           ora      #$0100
           sta      SMURF+ShellID

           lda      MasterID            do id for list use
           ora      #$0200
           sta      ListsID

           jsl      cSetUp              *** C *** Init some stuff incl. ETBL

           stz      QuitFlag            quitFlag flag set by loaderror or user


           PushWord #0
           _GetCurResourceFile
           ldx      #$0102
           jsl      shError2
           pla
           sta      GenFileID

           PushLong #0                  Space for result
           PushWord #refIsResource
           PushLong #1
           PushLong #0                  Is System Menu Bar
           _NewMenuBar2                 Do the Menu Bar
           ldx      #$0104
           jsl      shError2
           _SetSysBar                   THIS MUST BE HERE!
           ldx      #$0105
           jsl      shError2

           PushLong #0                  THIS MUST BE HERE TOO!
           _SetMenuBar
           ldx      #$0106
           jsl      shError2

           PushWord #AppleMenuID        Add DAs to Apple Menu
           _FixAppleMenu
           ldx      #$0107
           jsl      shError2

           PushWord #0                  Calc the menu sizes
           _FixMenuBar
           ldx      #$0108
           jsl      shError2
           pla

           _DrawMenuBar                 Draw it...
           ldx      #$0109
           jsl      shError2

           jsl      CloseFileMenuHi
           PushLong #EditMenuList
           PushWord #0                  Disable
           jsl      SetMenus

           jsr      GrabDP
           jsr      InstEditors         likewise
           jsr      FreeDP

           _InitCursor                  must init cause of StartUpTools call

           PushLong ADialogP            close the about
           _CloseWindow
           ldx      #$0110
           jsl      shError2

           PushWord #0
           PushWord #3
           PushLong #0
           PushLong #GenData
           _OpenResourceFile
           bcc      dataOpen
           cmp      #$50
           bne      dataFail

           PushWord #0                  Result
           PushWord #4                 C str resource
           PushLong #0                  Substitution string
           PushLong #13
           _AlertWindow
           pla
           pla
           brl      ShutDown

dataFail   ldx      #$0120
           jsl      shError2

dataOpen   pla
           sta      GenDataID

           PushWord #-1
           PushWord GenFileID
           jsl      SetResAccess

           PushWord #0                  Clipboard stuff initialization
           _GetScrapCount                 o
           ldx      #$0130
           jsl      shError2
           pla                            o
           sta      ClipCount             o
           stz      ClipWPtr
           stz      ClipWPtr+2

           PushWord #0                  This Key translation shit was
           _getKeyTranslation           blessed by Pope Apple the II
           ldx      #$0140
           jsl      shError2
           PullWord OldKeys             via Mike via Kevin and entered
           PushWord #0                  via the deft fingers of Marc
           _setKeyTranslation
           ldx      #$0141
           jsl      shError2

           lda      QuitFlag
           bne      LoadFail
*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
           jsr      mainEvent           main event loop
*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
           lda      QuitFlag
           bmi      NoXfer

           jsr      SetQuitApp
           sta      quitPath
           stx      quitPath+2
           ora      quitPath+2
           beq      NoXfer
           lda      #2
           sta      quitParms   * A nice place for setting restart :)

NoXfer     _WaitCursor
           PushLong #0
           _GetPort                     Left on the stack...
           PushLong #UnloadTemp
           jsl      IODialog
           sta      DlogPtr
           stx      DlogPtr+2

           _UnloadScrap
           ldx      #$0152
           jsl      shError2

           PushLong DlogPtr
           _CloseDialog
           ldx      #$0154
           jsl      shError2
           _SetPort

LoadFail   PushWord OldKeys             Undoes tha above
           _setKeyTranslation
           ldx      #$0160
           jsl      shError2

           PushWord GenDataID
           _CloseResourceFile
           ldx      #$0170
           jsl      shError2

ShutDown   PushWord #refIsHandle        Now shut them all down
           PushLong initRef             ref ptr from StartUpTools
           _ShutdownTools               Do it!

           PushWord #0                  result space (first seed)
           ldx      #128                generic index first
KillEdLoop lda      EUID,x              userID or 0
           beq      EdIsDead
           pha
           PushWord #0                  quitflag
           stx      temp
           _UserShutdown
           ldx      temp
EdIsDead   dex
           dex
           bpl      KillEdLoop          returned userID new result space or...
           pla                            pulled if the dirty work is done!

           PushWord MasterID
           _MMShutdown
AbortExit  _TLShutdown

           pld                          Restore D.P.
           plb

           _QuitGS quitParms            Leave here

temp       dc       i2'0'

initRef    dc       i4'0'               Space for ptr from StartUpTools

OldKeys    dc       i2'0'

quitParms  dc       i2'0'               Parameter Count (min = 0)
quitPath   dc       i4'0'               Ptr to pathname (next application)
quitFlags  dc       i2'0'               Flags (restartability, mem)

GSOSVer    dc       i2'1'
Version    dc       i2'0'

closeAll   dc       i2'1,0'

ShellRev   ENTRY
           str      'Shell v2.0a12'
LoadNote   str      'Version 2.0a12    ...this will never end!'

ToolHandle ds 4

           END

mainEvent  START
*****************************************************************
*
*   mainEvent
*
*****************************************************************
*
           using    Shell

           stz      SMURF+EditModifiers
           stz      MItemTbl
           stz      Null2Exit
           stz      SESidx

           PushLong #0
           PushWord #1
           jsl      EOS_Special

loop       jsl      ChkEdMenu
           jsl      ShellCoords         menubar coordinates
           jsl      ClipEvent           clipboard manager

           PushLong #RegularMask

           lda      SubEditActive
           beq      setMask

           and      #SEnew+SEcomplete
           bne      setMask
           lda      SubEditActive
           and      #SEactive
           beq      setMask

           PushWord #0
           PushWord #2                  Mouse Down
           PushLong #SEventRec
           _EventAvail
           pla
           beq      subMask

           PushWord #0
           PushLong #SWinPtr
           PushWord SEventXpt
           PushWord SEventYpt
           _FindWindow
           ldx      #$0202
           jsl      shError2
           pla
           cmp      #$1b
           bne      subMask

           PushLong #0
           _FrontWindow
           ldx      #$0203
           jsl      shError2
           pla
           plx
           cpx      SWinPtr+2
           bne      subMask
           cmp      SWinPtr
           beq      setMask

subMask    lda      #<SpecialMask
           sta      1,s
           lda      #^SpecialMask
           sta      3,s

setMask    lda      SMURF+EditModifiers
           and      #modNoCtrl
           beq      stdMask

           pla
           ora      taskORmask
           and      taskANDmask
           pha

           lda      3,s
           ora      taskORmask+2
           and      taskANDmask+2
           sta      3,s

stdMask    pla
           plx
           sta      SMURF+wmTaskMask
           stx      SMURF+wmTaskMask+2

           pha                          Call TaskMaster
           pea      $FFFF               all events
           pushlong #SMURF              use smurf as taskrecord
           _TaskMaster
           pla
           sta      SMURF+TaskCode      SMURF
           asl      A                   Turn it into an index
           tax
           jsr      (TaskTable,x)       Call appropriate event handler

           lda      QuitFlag            Quit selected?
           bne      ignore
           brl      loop                no - keep looping

ignore     rts

SpecialKey ANOP
           PushLong #0
           _FrontWindow
           ldx      #$02E0
           jsl      shError2
           pla
           plx
           cmp      HelpWinPtr
           bne      notHelp
           cpx      HelpWinPtr+2
           bne      notHelp
           jsl      doHelpKey
           rts
notHelp    jmp      doEdit              --- returns after jsr (tasktable,x)

SpecialDrag ANOP
           lda      SubEditActive
           bmi      ShellDrag
           jmp      doEdit              --- returns after jsr (tasktable,x)
ShellDrag  PushWord #2
           PushLong SMURF+wmWhere
           PushWord #8
           PushLong #0
           PushLong SMURF+wmTaskData
           _DragWindow
           ldx      #$02E2
           jsl      shError2
           rts

SubLoop    ENTRY    RTL
           phb      bRTL
           phk
           plb



TaskTable  dc       i2'doNull'          00 Null
           dc       i2'doEdit'          01 MouseDown
           dc       i2'doEdit'          02 MouseUp
           dc       i2'SpecialKey'      03 KeyDown
           dc       i2'ignore'          04 undefined
           dc       i2'doEdit'          05 AutoKey
           dc       i2'doEdit'          06 Update
           dc       i2'ignore'          07 undefined
           dc       i2'Wizard'          08 Activate -Magic performed upon demand
           dc       i2'ignore'          09 Switch
           dc       i2'ignore'          0A Desk accessory
           dc       i2'ignore'          0B Device driver
           dc       i2'ignore'          0C ap
           dc       i2'ignore'          0D ap
           dc       i2'ignore'          0E ap
           dc       i2'ignore'          0F ap
           dc       i2'doEdit'          10 indesk
           dc       i2'doMenu'          11 in menuBar
           dc       i2'doEdit'          12 in system window
           dc       i2'doEdit'          13 in content
           dc       i2'SpecialDrag'     14 in Drag
           dc       i2'doEdit'          15 in grow
           dc       i2'doExit'          16 in goaway
           dc       i2'doEdit'          17 in zoom
           dc       i2'doEdit'          18 in info bar
           dc       i2'doMenu'          19 in special menu
           dc       i2'ignore'          1A in NDA
           dc       i2'doEdit'          1B in frame
           dc       i2'ignore'          1C inactive menu
           dc       i2'ignore'          1D desk accessory colsed
           dc       i2'ignore'          1E system edit called
           dc       i2'doEdit'          1F zoom box clicked
           dc       i2'doEdit'          20 button down on frame
           dc       i2'doCtrl'          21 button or keystroke in control

SEventRec  ds       10
SEventYpt  ds       2
SEventXpt  ds       4

SWinPtr    ds       4

           END

SubEditHell START        long SubEditHell(int rType, long rID, Handle rHndl)
           phb
           phk                          123456789abcd
           plb                          bRTLrTr_IDhndl

           jsl      SaveSMURF           EOS routine returns SMURF handle
           phx
           pha

           tsx                          sHanbRTLrTr_IDrHan
           txa                          ^
           ldx      SESidx              |
           sta      SEStack,x           |
           inx
           inx
           stx      SESidx

           ........................more to come......................
SMURFh     ds       4

           END

Wizard     START
*****************************************************************
*
*   Wizard - called as a preprocessor for activate events to make
*          magic occur in swapping out editor windows via the new
*          refcon dispatch strategy...  Other magic performed per
*          appropriate assumptions.
*
*****************************************************************
*
           using    Shell

           PushLong SMURF+wmTaskData    window pointer
           jsl      RefConSetup         sets the SMURF and gives winKind
           cmp      #-1
           beq      notOurWin

           cmp      #$5752
           bne      notRoot
           brl      checkSEret

notRoot    cmp      #$5751
           bne      notHelp

           ldx      #wmModifiers
           lda      SMURF+wmModifiers
           and      #1
           beq      endHelp             deactivate help window

           PushWord #0                  activate help window
           _GetKeyTranslation
           ldx      #$0302
           jsl      shError2
           PullWord CurTrans
           PushWord #$ff
           _SetKeyTranslation
           ldx      #$0303
           jsl      shError2
notOurWin  bra      NullMenu6

endHelp    PushWord CurTrans
           _SetKeyTranslation
           ldx      #$0304
           jsl      shError2
           rts

notHelp    tax
           and      #$ff00
           cmp      #$5700
           beq      NullMenu6

           txa
           pha
           sta      CurWinType

           jsr      ResTypeIdx
           cpx      #-1
           beq      noEditor            br = no editor (not even mikes generic)

           pla                          B8: DataView support
           and      #$0008
           beq      notGeneric
           ldx      #128

notGeneric lda      SMURF+wmModifiers
           and      #1                  Check activate or deactivate
           beq      deactivate
           brl      activate            br = activate event

deactivate lda      #EditRes            Set up EditRes command (2)
           sta      SMURF+EditCommand   Put in smurf
           jsr      Dispatcher          Call the editor

           lda      SMURF+wmTaskData
           cmp      NewSubOwner
           bne      NullMenu6
           ldx      SMURF+wmTaskData+2
           cpx      NewSubOwner+2
           bne      NullMenu6

           stz      NewSubOwner
           stz      NewSubOwner+2

NullMenu6  ldx      #0
nullLoop   lda      MItemTbl,x
           beq      nullExit

nullItem   phx
           pha
           _DeleteMItem
           ldx      #$0310
           jsl      shError2
           plx
           inx
           inx
           bra      nullLoop

nullExit   lda      MItemTbl
           bne      nullMBar
noEditor   rts

nullMBar   stz      MItemTbl
           PushWord #0
           PushWord #0
           PushWord #6
           _CalcMenuSize
           ldx      #$0312
           jsl      shError2
           PushWord #$0080
           PushWord #6
           _SetMenuFlag
           ldx      #$0313
           jsl      shError2
           PushWord #0
           PushWord #6
           _HiLiteMenu
           ldx      #$0314
           jsl      shError2
           rts

checkSEret stz      SubEditActive
           PushLong #LiveMenuList
           PushWord #1                  Enable
           jsl      SetMenus
           jsl      CheckHide
           PushLong #NoSEMenuList
           PushWord #1                  Disable
           jsl      SetMenus
           brl      NullMenu6

activate   phx                          index to the editor table
           phx                          TWICE!

           jsr      NullMenu6           see if a residual menu must die

           plx                          one down...
           txa
           asl      a
           tax
           lda      ENM2+2,x
           ora      ENM2,x
           bne      menu6Valid
           brl      SkipMenu

menu6Valid phd                          Setting up a mini-frame...
           pha
           pha
           clc
           lda      ENM2,x
           adc      #10
           pha                          space for hi...
           pha                            ...real lo value
           lda      ENM2+2,x
           adc      #0
           sta      3,s                   ...real hi value
           tsc
           tcd                          ...frame inplace

           ldx      #0                  Start of MItemTbl
menu6Loop  ldy      #2                  Offset to the MItem ID
           lda      [1]
           sta      5
           lda      [1],y               Have ID
           sta      7
           ora      5
           beq      menu6Done
           lda      [5],y               Have ID
           sta      MItemTbl,x          Save it in MItemTbl
           inx                          Point to next space
           inx
           stz      MItemTbl,x          Zero it...
           phx

           PushWord #0
           lda      7
           pha
           lda      5
           pha
           PushWord #$ffff
           PushWord #6
           _InsertMItem2
           ldx      #$0320
           jsl      shError2

           clc
           lda      1
           adc      #4
           sta      1
           lda      3
           adc      #0
           sta      3

           plx
           bra      menu6Loop

menu6Done  pla
           pla
           pla
           pla
           pld

           lda      MItemTbl
           beq      SkipMenu

           PushWord #0
           PushWord #0
           PushWord #6
           _CalcMenuSize
           ldx      #$0330
           jsl      shError2
           PushWord #$ff7f
           PushWord #6
           _SetMenuFlag
           ldx      #$0331
           jsl      shError2
           PushWord #0
           PushWord #6
           _HiLiteMenu
           ldx      #$0332
           jsl      shError2

SkipMenu   PushWord #0
           PushLong SMURF+ResourceID   setup the item's name in EditResult2
           PushWord SMURF+ResourceType
           jsl      get_label
           phx
           pha
           jsl      c2pstr
           sta      SMURF+EditResult2
           stx      SMURF+EditResult2+2

           ldy      #EditRes            Set up EditRes command (2)

           lda      SubEditActive       See if the last editor was a sub editor
           tax                          that is now complete
           and      #SEcomplete
           beq      simpleEdit          br = no

           ldy      #EditReturn         Set dispatcer thusly

           txa                          Clear complete flag
           eor      #SEcomplete
           sta      SubEditActive

           lda      ActSubType          Setup EquateType and EquateID with sub
           sta      SMURF+EquateType    editor data
           lda      ActSubID
           sta      SMURF+EquateID
           lda      ActSubID+2
           sta      SMURF+EquateID+2

simpleEdit lda      CurWinType          Now see what WE are
           and      #$fff7              First strip generic editor out...
           cmp      #1                  subeditor?
           beq      setSubWin           br = sub

           phy
           PushLong #LiveMenuList
           PushWord #-1                 Enable
           jsl      SetMenus
           jsl      CheckHide
           PushLong #NoSEMenuList
           PushWord #-1                 Enable
           jsl      SetMenus
           ply

           lda      SubEditActive
           bpl      regularOut
           eor      #SEactive
           sta      SubEditActive
           bra      regularOut

setSubWin  phy
           PushLong #LiveMenuList
           PushWord #0                  Disable
           jsl      SetMenus
           PushLong #NoSEMenuList
           PushWord #0                  Disable
           jsl      SetMenus
           ply

           lda      SubEditActive       Set active flag
           ora      #SEactive
           sta      SubEditActive

           lda      SMURF+ResourceType
           sta      ActSubType
           lda      SMURF+ResourceID
           sta      ActSubID
           lda      SMURF+ResourceID+2
           sta      ActSubID+2

regularOut plx                          second DONE!
           sty      SMURF+EditCommand   Put in smurf
           jsr      Dispatcher          Call the editor

ExitNow    RTS

CurWinType ds       2
CurTrans   ds       2


           END

doNull     START
*****************************************************************
*
*   doNull - called every null, update and activate event to
*          dispatch a NullRes call to the appropriate editor.
*
*   doEdit - called for almost every event, this puppy dispatches
*          an EditRes call to the appropriate editor.
*
*   doExit - called for go-away and from doExitL (menu dispatch)
*            for Close Menu selection
*
*   doExitL - Allows us to call doExit (jsr) from menu dispatch (jsl)
*
*****************************************************************
*
           using    Shell

           lda      SubEditActive       See if something is in the wind
           and      #SEnew              as far as sub editors go
           bne      newSubEdit          Nothing special

           lda      Null2Exit
           bne      suicide

           lda      #EditNull           Set up NullEdit command (5)
           sta      SMURF+EditCommand   Put it in Smurf
           jsr      RTDispatch          Call the editor

           PushWord #FileRevertID       Setup revert menu item
           lda      SubEditActive       is a subedit active?
           bmi      revertOff           yes, disable
           lda      SMURF+EditModifiers has the file changed
           bmi      revertOn            yes, enable
revertOff  _DisableMItem                no, disable
           ldx      #$0401
           jsl      shError2
           RTS
revertOn   and      #modNewFile         is the file new?
           bne      revertOff
           _EnableMItem
           ldx      #$0402
           jsl      shError2
           RTS

newSubEdit ANOP

           lda      #5                  Set up a createSub dispatch
           sta      SMURF+EditCommand   Put it in Smurf

           lda      NewSubType          Setup SMURF
           sta      SMURF+ResourceType
           lda      NewSubID
           sta      SMURF+ResourceID
           lda      NewSubID+2
           sta      SMURF+ResourceID+2

           lda      SMURF+EditModifiers Set the SubEdit flag
           ora      #modSubEdit
           sta      SMURF+EditModifiers

           lda      SubEditActive       Clear the SEnew flag
           eor      #SEnew
           sta      SubEditActive

           jsr      ResTypeIdx          Get the editor index X
           cpx      #-1
           beq      noEditor

           jsr      Dispatcher          Call the editor

noEditor   RTS

suicide    stz      Null2Exit

doExit     ENTRY                        *************************
           PushLong #0                  Check if our window
           _FrontWindow
           ldx      #$0410
           jsl      shError2
           jsl      RefConSetup
           cmp      #$FFFF
           bne      notSystem
           lda      #0
           RTS

notSystem  cmp      #$5752
           bne      notRoot
           JSL      CloseRoot           Its ours, Close up shop
           lda      #0
           RTS

notRoot    cmp      #$5754
           bne      notView
           jsl      closeTEWin
           RTS

notView    cmp      #$5751              "QW"
           bne      notHelp
           jsl      closeHelpWin
           RTS

notHelp    cmp      #$5753
           bne      notClip
           jsl      closeClip
           RTS

notClip    pha
           and      #$ff00
           cmp      #$5700
           bne      chkEdit
           pla

           PushLong #0                  Check if our window
           _FrontWindow
           ldx      #$0420
           jsl      shError2
           _CloseWindow
           ldx      #$0422
           jsl      shError2

           RTS

chkEdit    pla
           cmp      #1
           bne      notSubEdit

           lda      SubEditActive
           bpl      setSEdone
           eor      #SEactive
setSEdone  ora      #SEcomplete         This is a dead bug (AND #SEcomplete)
           sta      SubEditActive

notSubEdit PushLong #0                  Simulate an inGoAway...
           _FrontWindow
           ldx      #$0430
           jsl      shError2
           PullLong SMURF+wmTaskData      TaskData gets the front window
           ldx      #$16
           stx      SMURF+TaskCode        TaskCode gets an inGoAway mouse hit
           ldx      #EditRes            Set up Edit Resource command 2
           stx      SMURF+EditCommand
           jsr      RTDispatch          Dispatch call to Editor
           jsl      ChkLastEd
           RTS                          G'Nite Johnboy!

doEdit     ENTRY                        *************************

           ldx      #EditRes            Set up Edit Resource command 2
           stx      SMURF+EditCommand
           jsr      RTDispatch          Dispatch call to Editor

           RTS                          G'Nite Johnboy!

doExitL    ENTRY                        *************************

           phd
           phb
           phk
           plb

           jsr      doExit              close a window

           plb
           pld

           RTL

Null2Exit  ENTRY                    Set in EOS Special, 2...
           ds       2
           END

doMenu     START
*****************************************************************
*
*   doMenu - Routes a menu hit to the appropriate function
*
*  Inputs: MenuItemID in SMURF+wmTaskData
*          MenuTable
*
* Outputs:
*
*****************************************************************
*
           using    Shell

           _InitCursor                  this is only for the editors benefit

           PushWord #0                  Push this...
           PushWord SMURF+wmTaskData+2  And save menu ID for HiLiteMenu call

           lda      SMURF+wmTaskData    Get the item ID of menu item selected.

           cmp      #2048               Is it less than an editor menu item?
           blt      isShell             Yes, so it's really mine!

           lda      #EditRes            Edit Command = 2
           sta      SMURF+EditCommand   store in Smurf

           jsr      ResTypeIdx
           cpx      #-1
           beq      BackHere

haveEdit   jsr      Dispatcher          call EDitor

BackHere   anop

           jsl      ErrMsg

           _HiLiteMenu                  menu num is on stack (dehi menu)
           ldx      #$0510
           jsl      shError2

           rts

* These are for the Shell menu hits.
* This stuff is mine... we don't dispatch any editor calls here.  Also please
* note that the routines we're calling are all jsl/rtl based!
* These stuff is because you cant JSL to an offset index, just leave it alone!

isShell    sec                          Turn the MenuID into an index by
           sbc      #FirstMenuID        subtracting the starting ID number
           asl      a                   and then multiplying by 4
           asl      a
           tax                          Index...

* function rtl return address...
           phk                          Our code bank       (one byte)
           pea      BackHere-1          Our "rtl" address   (two bytes)

* psuedo jsl to function...
           SHORTM
           lda      MenuJSLtbl+2,x      Menu code bank      (one byte)
           pha
           LONGM
           lda      MenuJSLtbl,x        Menu "jsl" address  (two byes)
           pha

* this rtl will return at label BackHere, above...
           rtl                          This is when a rtl is really a jsl...

temp       ds       2

future     lda      #0
           rtl

MenuJSLtbl anop                         starting with an index of 250...

           dc       i4'EdUndo-1'        250 Undo
           dc       i4'EdCut-1'         251 Cut
           dc       i4'EdCopy-1'        252 Copy
           dc       i4'EdPaste-1'       253 Paste
           dc       i4'EdClear-1'       254 Clear
           dc       i4'doExitL-1'       255 Close
           dc       i4'doMenuAbout-1'   256 Apple
           dc       i4'doQuit-1'        257 Quit
           dc       i4'doHelp-1'        258 Help
           dc       i4'NewRez-1'        259 New

           dc       i4'OpenRez-1'       260 Open
           dc       i4'SaveRez-1'       261 Save
           dc       i4'SaveAsRez-1'     262 Save As
           dc       i4'GenSrc-1'        263 Generate Source
           dc       i4'ShowClip-1'      264 Show Clipboard
           dc       i4'ShowCoord-1'     265 Show Coordinates
           dc       i4'ImportFile-1'    266 Import File
           dc       i4'SetPrefs-1'      267 Preferences
           dc       i4'ResetOrigin-1'   268 Reset Origin
           dc       i4'SetOrigin-1'     269 Set Origin

           dc       i4'NewApp-1'        270 New application
           dc       i4'0'
           dc       i4'doQuitTo-1'      272 Quit to
           dc       i4'RevertRez-1'     273 Revert
           dc       i4'ComingSoon-1'    274
           dc       i4'DoChooseLang-1'  275 Choose Language
           dc       i4'DoHideRoot-1'    276 Hide Root Window
           dc       i4'DoShowRoot-1'    277 Show Root Window
           dc       i4'ComingSoon-1'    278 Pack resource fork
           dc       i4'ViewSource-1'    279 View Source

           dc       i4'ComingSoon-1'    280 Global Attributes
           dc       i4'0'
           dc       i4'0'
           dc       i4'doNextWindow-1'  283 NextWID
           dc       i4'0'
           dc       i4'ComingSoon-1'    285 Check resource map
           dc       i4'0'
           dc       i4'0'
           dc       i4'0'
           dc       i4'ComingSoon-1'    289 Resource toolbox

           dc       i4'ComingSoon-1'    290  Clipboard->library
           dc       i4'ComingSoon-1'    291  Library->clipboard
           dc       i4'ComingSoon-1'    292  Show infobar

           END

doCtrl     START
*****************************************************************
*
*   doCtrl - Routes a control hit in the root windows
*
*****************************************************************
*
           using    Shell

           PushLong #0
           _FrontWindow
           ldx      #$0602
           jsl      shError2
           pla
           plx

           cmp      HelpWinPtr
           bne      notHelp
           cpx      HelpWinPtr+2
           bne      notHelp
           jsl      doHelpCtrl
           rts

notHelp    cmp      RootWPtr
           bne      notRoot
           cpx      RootWPtr+2
           beq      chkParts
notRoot    brl      NotOurs             give to editor

chkParts   lda      SMURF+wmTaskData3   Part codes...
           cmp      #5                  List up arrow
           beq      SkipIt
           cmp      #6                  List down arrow
           beq      SkipIt
           cmp      #7                  List page up
           beq      SkipIt
           cmp      #8                  List page down
           beq      SkipIt
           cmp      #$81                List thumb
           beq      SkipIt

********************************************************
* get here, must be a valid somthing in our root window
********************************************************

* check for Add Pop Up hit
           lda      SMURF+wmTaskData4   Get the control ID
 
           cmp      #1                  Add Popup
           bne      EPop                br = check next
           jsr      parsePop            Get the menu ID
           jsr      handleAdd           Handle Add pop Up

SkipIt     rts

* check for Item Pop Up hit

EPop       cmp      #2                  Edit Popup
           bne      TLst                br = check next
           jsr      parsePop            Get menu ID
           sta      Action
           jsr      PopPicker
           rts

***********
TLst       cmp      #3                  Type List
           bne      ILst                br = check item list hit
           PushWord #0
           jsl      updateList          update types list
           rts

**************
ILst       cmp      #4                  Item List
           bne      BadShit             br = no (s)hit bud

           PushWord #1
           jsl      updateList          update items list

           lda      SMURF+wmClickCount  get the curr click count
           cmp      #2                  is it a double click?
           beq      Double              br = yes
           rts                          else return

Double     anop                         We have a double click
           lda      Action
           jsr      PopPicker

           RTS

NotOurs    anop                         MUST BE EDITORS
           lda      #EditRes            Command = 2
           sta      SMURF+EditCommand   Store in Smurf
           lda      SMURF+ResourceType  running editor?
           beq      BadShit             br = no

           jsr      RTDispatch          Call the active Editor!

BadShit    RTS

********************************************************
* routine to get menu ID selected in a popup
********************************************************
parsePop   PushWord #0                  Result
           PushLong SMURF+wmTaskData2   Control handle
           _GetCtlValue        
           ldx      #$0630
           jsl      shError2
           pla                          Get menu ID
           rts

**************************************************************************
PopPicker  cmp      #PopItemID          Edit Popup: Item?
           bne      EPar                br = no
           jsr      handleEdit          yes, handle it

           RTS

EPar       cmp      #PopParmID          Edit Popup: Parameters?
           bne      EDel                br = no

           lda      ListIrID            Proceed, is an Item selected?
           ora      ListIrID+2
           beq      noItem              br = no

           PushLong ListIrID            Get selected resItem...
           PushWord ListType                  ...and resType members
           jsl      EditAttr            Zap it!

noItem     rts

EDel       cmp      #PopKillID          Edit Popup: Delete?
           bne      EHex                br = no

           lda      ListIrID            Proceed, is an Item selected?
           ora      ListIrID+2
           beq      noItem              br = no

           PushLong ListIrID            Get selected resItem...
           PushWord ListType                  ...and resType members
           jsl      EditKill            Zap it!
           bne      setChange
           rts

setChange  lda      SMURF+EditModifiers
           ora      #$8000
           sta      SMURF+EditModifiers
           lda      #0
           rts

EHex       cmp      #PopDataID          Edit Popup: Data view?
           bne      Exfr                br = no

           jsr      handleData          yes, handle it

notaPop    rts

Exfr       cmp      #PopXferID          Edit Popup: Export?
           bne      notaPop             br = no

           PushLong #0
           _GetPort
           PushWord #160                Ask user where he wants New
           PushWord #30
           PushWord #0                  Next param is Pointer
           PushLong #ExpPrompt
           PushWord #0                  Next param is Pointer
           PushLong ListIrID            |
           PushWord ListType            |- these leave a long on the stack that
           jsl      ExportName          |  points to the class 1 input string
           phx                          |  derived from the outbound resource
           pha                          |
           PushLong #NewReply
           _SFPutFile2
           ldx      #$0631
           jsl      shError2
           _SetPort

           lda      NewReply
           beq      expExit

           PushLong ListIrID
           PushWord ListType
           PushLong #I1PName            Class 1 Input string
           jsl      ExportRez

expExit    rts

**************************************************************************
handleAdd  pha                          Save the menu id

           PushLong #0
           _RealFreeMem
           ldx      #$0640
           jsl      shError2
           pla
           plx
           cpx      #0
           bne      memoryOk
           cmp      #$8000
           bge      memoryOk

           PushWord #0
           PushWord #4
           PushLong #0                  Substitution string
           PushLong #12
           _AlertWindow
           pla
           rts

memoryOk   pla                          menu
           ldx      #0                  Set typical Ed menus ID walk index
getMenu    cmp      EMID,x              look for our menu ID in Ed Menus
           beq      haveMenu            Found it... branch onward
           inx
           inx
           bra      getMenu

haveMenu   lda      ERES,x              Get the rType for our editor
           sta      SMURF+ResourceType  Set rType in its SMURF field
           stz      SMURF+EditCommand   INITIALIZE Comand = 0
           stz      SMURF+ResourceID    Set up new resource request
           stz      SMURF+ResourceID+2
           jsr      Dispatcher          Call the editor
           jsl      ErrMsg

           rts

**************************************************************************
handleEdit stz      SMURF+EditCommand   Initialize Command = 0 (most likely)

           lda      ListIrID            Proceed, is an Item selected?
           ora      ListIrID+2            o
           bne      IDgood                o
           rts

IDgood     lda      ListIrID            Store item resID in smurf
           sta      SMURF+ResourceID
           lda      ListIrID+2
           sta      SMURF+ResourceID+2
           lda      ListType            Get selected resType member
           sta      SMURF+ResourceType  Store in Smurf

           jsr      ResTypeIdx
           phx
           cpx      #-1
           beq      editDone

           jsl      ChkAlreadyEdit      Play with the windows
           beq      editDone            Found one so skip dispatch

           PushLong SMURF+ResourceID
           PushWord SMURF+ResourceType
           jsl      CheckAttrWP
           cmp      #0
           bne      editDone

callEditor plx
           jsr      Dispatcher          Call the Editor

           jsl      ErrMsg

           phx
editDone   plx
           rts

handleData stz      SMURF+EditCommand   Initialize Command = 0 (most likely)

           lda      ListIrID            Proceed, is an Item selected?
           ora      ListIrID+2            o
           bne      IDgood2               o
           rts

IDgood2    lda      ListIrID            Store item resID in smurf
           sta      SMURF+ResourceID
           lda      ListIrID+2
           sta      SMURF+ResourceID+2
           lda      #-1                 Intentionally bad type...
           sta      SMURF+ResourceType  Store in Smurf

           jsr      ResTypeIdx
           phx
           cpx      #-1
           beq      editDone

           lda      ListType            Get selected resType member
           sta      SMURF+ResourceType  Store in Smurf

           jsl      ChkAlreadyEdit      Play with the windows
           beq      editDone            Found one so skip dispatch

           bra      callEditor

           END

RTDispatch START
*****************************************************************
*
*   RTDispatch      (JSR)
*
*  Input:  Command in SMURF+EditCommand
*
* Outputs: Error in A or NULL if ok
*
*   Dispatcher      (JSR)
*
*  Inputs: X word offset in ETable
*          Command in SMURF+EditCommand
*
*   ResTypeIdx      (JSR)
*
*  Input:  Resource type in SMURF+ResourceType
*
* Outputs: X word offset in ETable (-1 if no generic)
*
*   CallEditor      (JSL)
*
*  Inputs: Type, ID and Command in SMURF
*
*****************************************************************
*
           using    Shell

           PushLong #0
           _FrontWindow
           ldx      #$0702
           jsl      shError2
           jsl      RefConSetup         (MWW) 27Nov89 was GetWinResData
           cmp      #-1                 (MWW)  2Jun90 holy shit!
           beq      blowOut

           and      #$0008              B8: DataView support
           beq      notGeneric
           ldx      #128
           bra      Dispatcher

notGeneric lda      ECNT                get number of loaded editors
           asl      a                   *2
           tax                          place in X

           lda      SMURF+ResourceType  Editor active?
           bne      checkRID            br = yes
blowOut    stz      LastType
           lda      #0                  This fixes all the Error $ffff shit
           RTS                          No Active editor, get the fuck out!

checkRID   cmp      LastType            Called previously?
           bne      GetResType          Nope... get a new address

           phb                          Yes... do it again (no muss/fuss)
           pushlong #SMURF              Setup the parameter
           phk                          Our "rtl" bank    (one byte)
           pea      EditRtn-1           Our "rtl" address (two bytes)

           SHORTM                       * Reset the editors entry_address-1
           lda      LastAddr+2          *   o
           pha                          *   o
           pha                          *   o
           LONGM                        *
           lda      LastAddr
           plb
           pha

           brl      Go_Edit

GetResType jsr      ResTypeIdx
           cpx      #-1
           bne      Dispatcher

           RTS

Dispatcher ENTRY
           lda      SMURF+ResourceType  This may have been a buggggGGGGGG!
           cpx      #128
           beq      DoGeneric

           lda      ERES,x              This handles setup from Dispatcher...

DoGeneric  sta      LastType
           txa                          Convert word index to long
           asl      a
           tax

           phb
           pushlong #SMURF         Setup the parameter
           phk                          Our "rtl" bank    (one byte)
           pea      EditRtn-1           Our "rtl" address (two bytes)

           SHORTM                       *
           lda      EADR+2,x            *
           pha                          *
           sta      LastAddr+2          *
           pha                          * Future data bank
           LONGM                        *
           sec                          Setup the editors entry_address-1
           lda      EADR,x                o
           sbc      #1                    o
           sta      LastAddr              o
           plb                          Would I kid you?
           pha

Go_Edit    lda      >GenFileID
           sta      >SMURF+ShellResFileID
           lda      >ResFileID
           sta      >SMURF+ResourceFileID
           pha
           _SetCurResourceFile
           ldx      #$0750
           jsl      shError2
           PushWord #0
           PushWord #-1
           _SetResourceFileDepth
           ldx      #$0751
           jsl      shError2
           pla

           rtl                          When a rtl is really a jsl...

EditRtn    plx                          See if we restore the stack
           ply                            o
           cpx      #<SMURF               o
           bne      Its_done              o
           cpy      #^SMURF
           beq      We_do_it

Its_done   phy                          No... they did it so put it back
           phx

We_do_it   anop
           plb
           pha                          Save any error value

           PushWord #-1
           PushWord GenFileID
           jsl      SetResAccess

           lda      SMURF+EditModifiers       SMURF
           and      #modSubEdit
           beq      ErrorOut

           lda      SMURF+EquateType
           sta      NewSubType
           lda      SMURF+EquateID
           sta      NewSubID
           lda      SMURF+EquateID+2
           sta      NewSubID+2

           lda      SMURF+EditModifiers       SMURF
           eor      #modSubEdit
           sta      SMURF+EditModifiers

           lda      SubEditActive
           ora      #SEnew
           sta      SubEditActive

           lda      #0
           pha
           pha
           pha
           _FrontWindow
           ldx      #$0770
           jsl      shError2
           pla
           sta      NewSubOwner
           pla
           sta      NewSubOwner+2

           pla
ErrorOut   anop
           ldy      SMURF+EditCommand
           cpy      #EditInit2
           beq      ErrorRet
           jsl      ErrMsg              check if error
           pla                          Restore error on stack
           jsl      ErrMsg              check if error
           RTS                          Home at last

ErrorRet   tax
           pla
           RTS

ResTypeIdx ENTRY                        Set X to a word index into the editors
           pha
           lda      ECNT
           asl      a
           tax
CheckNext  lda      ERES,x
           cmp      SMURF+ResourceType
           beq      HaveIdx

           dex
           dex
           bpl      CheckNext

           ldx      #128
           lda      GEDloaded
           bmi      HaveIdx

           PushWord #0                  Result
           PushWord #4                  C str resource
           PushLong #0                  Substitution string
           PushLong #1
           _AlertWindow
           pla
           ldx      #-1                 This is our badness indicator

HaveIdx    pla
           RTS

jsl_Editor ENTRY
           phb
           phd
           phk
           plb

           jsr      ResTypeIdx
           txa
           bmi      skipCall
           jsr      Dispatcher

skipCall   pld
           plb
           RTL

LastType   ds       2
LastAddr   ds       3

           END

ErrMsg     START    M_WOLFGRAM
*****************************************************************
*
*   ErrMsg
*
*  Inputs: Error in A
*
* Outputs: registers preserved across the call.
*
*****************************************************************
*
           cmp      #0                  ; is it 0?
           beq      errOut              ; br = no, no error

           phb
           phx
           phy
           phk
           plb
           sta      errNum              ; A must contain an error

           _InitCursor

           PushWord #0                  ; space for button press
           PushWord #1                  ; we use pascal type strings
           PushLong #message            ; the message to display
           PushWord errNum              ; the error number
           _ErrorWindow                 ; call up 5.0 ErrorWindow
           pla                          ; get the button press

           ply
           plx
           lda      errNum
           plb

errOut     RTL

errNum     ds       2
message    str      'GENESYS internal error'

           END

GrabDP     START
*****************************************************************
*
*   Stack sanity stuff...
*
*****************************************************************
*
           pha
           phx
           ldx      #6
Grab_2     lda      deref,x
           sta      TempDP,x
           dex
           dex
           bpl      Grab_2
           plx
           pla
           rts

FreeDP     entry
           pha
           phx
           ldx      #6
Free_2     lda      TempDP,x
           sta      deref,x
           dex
           dex
           bpl      Free_2
           plx
           pla
           rts

TempDP     ds       8

           end

ComingSoon START    M_WOLFGRAM
****************************************************************
*
* ComingSoon
*
* Marc Wolfgram
*
****************************************************************

           PushWord #0                  Result
           PushWord #4                  C str resource
           PushLong #0                  Substitution string
           PushLong #2
           _AlertWindow
           pla

           rtl

           END
